/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition ( scaled_gl_FragCoord.xy / u_WindowSize - vec2(0.5) )

/////////////////////////////////////////////////////////////////////////////////
 
// precision lowp float;
// uniform vec2 resolution;
// uniform float time;

float r=time/3.,i,ii;
float e(vec3 c)
{
  c = cos(vec3(cos(c.r+r/6.)*c.r-cos(c.g+r/5.)*c.g,c.b/3.*c.r-cos(r/7.)*c.g,c.r+c.g+c. b+r));
  return dot(c*c,vec3(1.))-1.0;
}

vec3 dv1(vec3 v)
{
    	for(int i = 1; i <5; i++)
    	{
        	v.yzx += sin((v.zxy+vec3(0.0,2.094395102,4.188790205))*(float(i)*0.3183098862))*3.141592654;
    	}
	return v;
}

vec3 dv2(vec3 v)
{
	vec4 v4 = vec4(dv1(v),(v.x+v.y+v.z)*0.3678794412);
    	for(int i = 1; i <3; i++)
    	{
        	v.yzx += (dv1(v4.xyz)+dv1(v4.yzw)+dv1(v4.zwx)+dv1(v4.wxy)+v.zxy)*(float(i)*0.01591549431);
    	}
	return normalize(v);
}

void main()
{
  vec2 c=-1.+2.0*scaled_gl_FragCoord.rg/resolution.xy;
  vec3 vct,o,g=vec3(c.r,c.g,1)/64.;
  vec4 v;
  for(float i=1.;i<666.;i+=1.0)
    {
      vct = o+g*i;
      float scn = e(vct);
      if(scn<.4)
        {
          vec3 r=vec3(.15,0.,0.),c=r;
          c.r=scn-e(vec3(vct+r.rgg));
          c.g=scn-e(vec3(vct+r.grg));
          c.b=scn-e(vec3(vct+r.ggr));
          v+=dot(vec3(0.,0.,-1.0),c)+dot(vec3(0.0,-0.5,0.5),c);
          break;
        }
        ii=i;
    }
  gl_FragColor=v+vec4(dv2(v.xyz+vct)*vec3(.1+cos(r/14.*cos(time+c.y))/9.,0.1,.1-cos(r/3.)/19.),1.)*(ii/44.);
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15
}
